# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import wait_for_element, parse_price, get_currency


def extractor(driver, variant_params, url, post):
    yield 'url', url
    yield get_with_screenshot(driver, url)

    price_element_selector = '.nemo-checkout-order-details__priceBlock__price'

    wait_for_element(driver, price_element_selector, 40)
    price_element = driver.find_element_by_css_selector(price_element_selector)

    price_text = price_element.get_attribute('amount')
    yield 'price_text', price_text
    currency_text = price_element.get_attribute('currency')
    yield 'currency_text', currency_text

    price = parse_price(price_element.get_attribute('amount'))
    currency = get_currency(currency_text)

    yield 'price', price_element
    yield 'currency', currency

    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    yield {
        'price': price,
        'currency': currency,
    }
