# -*- coding: utf-8 -*-
import os

import travel.avia.revise.lib.environment_variable_provider as env_variable_provider

LOG_PATH = os.getenv('AVIA_LOG_PATH', default='/var/log/yandex-avia-revise')

YANDEX_ENVIRONMENT_TYPE = env_variable_provider.get('ENVIRONMENT_TYPE')


# SELENIUM GRID QUOTA SELECTION
def format_selenium_grid_url(url, user, password):
    return 'http://{user}{password}@{url}'.format(
        url=url,
        user=user,
        password=':{}'.format(password) if password else '',
    )


selenium_grid_url_avia_quota = format_selenium_grid_url(
    url=env_variable_provider.get('SELENIUM_URL', 'sw.yandex-team.ru:80/v0'),
    user=env_variable_provider.get('SELENIUM_GRID_USER', 'avia'),
    password=env_variable_provider.get('SELENIUM_GRID_PASSWORD', ''),
)


def SELENIUM_GRID_URL_FOR_PARTNER(partner_code):
    return selenium_grid_url_for_partner.get(partner_code, selenium_grid_url_avia_quota)


# SELENIUM BROWSER CAPABILITIES SELECTION

def BROWSER_CAPABILITIES_FOR_PARTNER(partner_code: str):
    capabilities = browser_capabilities_default.copy()
    capabilities_for_partner = browser_capabilities_for_partner.get(partner_code)
    if capabilities_for_partner:
        capabilities.update(capabilities_for_partner)
    return capabilities


# SELENIUM GRID QUOTA SELECTION
# Add partner-specific options here
selenium_grid_url_for_partner = {
}

# SELENIUM BROWSER CAPABILITIES SELECTION
# Add partner-specifig options here
browser_capabilities_for_partner = {
    # 'kupibilet': {'version': '77.0'},
}

browser_capabilities_default = {
    'platform': 'ANY',
    'browserName': 'chrome',
    'version': '80.0',
}

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'root': {
        'level': 'DEBUG',
        'handlers': ['tree', 'error', 'traceback'],
    },
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s:%(lineno)s: %(message)s'
        },
        'simple': {
            'format': '%(message)s'
        },
        'error': {
            '()': 'ylog.ExceptionFormatter',
            'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
        },
        'traceback': {
            '()': 'ylog.ExceptionFormatter',
            'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
            'full': True,
            # 'show_locals': True
        },
    },
    'handlers': {
        'error': {
            'class': 'logging.handlers.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'error.log'),
            'formatter': 'error',
            'level': 'ERROR',
        },
        'traceback': {
            'class': 'logging.handlers.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'traceback.log'),
            'formatter': 'traceback',
            'level': 'ERROR',
        },
        'tree': {
            'level': 'DEBUG',
            'class': 'cloud_logger.handlers.ArcadiaFileTreeHandler',
            'base_path': LOG_PATH,
            'formatter': 'verbose',
            'remove_prefix': 'travel.avia.revise'
        },
    },
    'loggers': {
        'error': {
            'handlers': ['error'],
            'level': 'ERROR',
        },
        'traceback': {
            'handlers': ['traceback'],
            'level': 'ERROR',
        },
    }
}

if os.getenv('DEPLOY_UNIT_ID'):
    LOGGING['formatters']['deploy'] = {
        '()': 'cloud_logger.formatters.DeployJsonFormatter',
        'format': '%(name)s: %(message)s',
        'datefmt': '%Y-%m-%d %H:%M:%S',
    }
    LOGGING['handlers']['deploy_handler'] = {
        'level': 'INFO',
        'class': 'logging.StreamHandler',
        'formatter': 'deploy',
    }
    LOGGING['root']['handlers'].append('deploy_handler')
    for logger in LOGGING['loggers'].values():
        logger['handlers'].append('deploy_handler')

AVIA_STATS_REST_HOST = env_variable_provider.get('STATS_REST_HOST')
AVIA_STATS_OAUTH_TOKEN = env_variable_provider.get('STATS_OAUTH_TOKEN')
AVIA_STATS_REST_TIMEOUT = 30

SQS_ACCESS_KEY = env_variable_provider.get('SQS_ACCESS_KEY')
SQS_SECRET_KEY = env_variable_provider.get('SQS_SECRET_KEY')
SQS_ENDPOINT = env_variable_provider.get('SQS_ENDPOINT')
SQS_QUEUE_NAME = '{}_ticket_daemon_revise'.format(os.getenv('SQS_PREFIX', YANDEX_ENVIRONMENT_TYPE))

# SQS_ENDPOINT = 'http://sqs.yandex.net:8771'
# SQS_ACCESS_KEY = 'avia'
# SQS_SECRET_KEY = 'unused'

BROKER_TRANSPORT_OPTIONS = {
    'is_secure': False,
    'region': 'yandex',
}

API_LISTEN_PORT = os.getenv('AVIA_API_LISTEN_PORT', 80)

AVIA_SENTRY_DSN = os.getenv('AVIA_SENTRY_DSN')
