# coding: utf-8
import logging

import sentry_sdk
from sentry_sdk.integrations.logging import LoggingIntegration


def sentry_logging(dsn):
    if not dsn:
        logging.warning('No sentry DSN provided')
        return

    sentry_sdk.init(
        dsn=dsn,
        integrations=[
            LoggingIntegration(
                level=logging.INFO,  # Capture info and above as breadcrumbs
                event_level=logging.ERROR,  # Send errors as events
            ),
        ],
    )
