PY3_LIBRARY()

OWNER(g:avia)

PEERDIR(
    contrib/python/boto3
    contrib/python/celery
    contrib/python/contextlib2
    contrib/python/gevent
    contrib/python/Pillow
    contrib/python/pydantic
    contrib/python/requests
    contrib/python/selenium
    contrib/python/sentry-sdk
    contrib/python/tornado/tornado-4

    library/python/ylog

    travel/library/python/cloud_logger
)

PY_SRCS(
    api.py
    extractor/base_partner_extractor.py
    extractor/choices.py
    extractor/error.py
    extractor/extract.py
    extractor/report.py
    lib/environment_variable_provider.py
    lib/selenium_lib.py
    partners/aeroflot.py
    partners/aerotur.py
    partners/agent.py
    partners/amadeus.py
    partners/amadeus_tp.py
    partners/anywayanyday.py
    partners/avia_yandex.py
    partners/aviakass.py
    partners/awad.py
    partners/azimuth.py
    partners/biletdv.py
    partners/biletikaeroag.py
    partners/biletinet.py
    partners/biletix.py
    partners/bookandtrip.py
    partners/citytravel1.py
    partners/clickaviatravelab.py
    partners/expressavia.py
    partners/kiwi.py
    partners/kupibilet.py
    partners/megotravel.py
    partners/moireis.py
    partners/nebotravel.py
    partners/onetwotrip.py
    partners/onetwotripru.py
    partners/ozon.py
    partners/pobeda.py
    partners/redwings.py
    partners/rusline.py
    partners/s_seven.py
    partners/sindbad.py
    partners/smartavia.py
    partners/superkassa.py
    partners/supersaver.py
    partners/svyaznoy.py
    partners/tez_tour.py
    partners/ticketsru.py
    partners/tinkoff.py
    partners/tinkoff1.py
    partners/travelgenio.py
    partners/trip_ru.py
    partners/tripcom.py
    partners/tripway.py
    partners/tutu.py
    partners/ufs_plane.py
    partners/utair.py
    partners/u6.py
    partners/uzairways.py
    revise_task/celery_app.py
    revise_task/review.py
    settings.py
    utils/helpers.py
    utils/logs.py
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
