package app

import (
	"time"

	"a.yandex-team.ru/travel/avia/search_results_queue_producer/internal/dicts"
	"a.yandex-team.ru/travel/avia/search_results_queue_producer/internal/searchresultscache"
	"a.yandex-team.ru/travel/avia/search_results_queue_producer/internal/service/dynamicresources"
	"a.yandex-team.ru/travel/avia/search_results_queue_producer/internal/service/profiling"
	"a.yandex-team.ru/travel/avia/search_results_queue_producer/internal/service/qidconsumer"
	"a.yandex-team.ru/travel/avia/search_results_queue_producer/internal/service/queueproducer"
	"a.yandex-team.ru/travel/avia/search_results_queue_producer/internal/service/readiness"
	"a.yandex-team.ru/travel/avia/search_results_queue_producer/internal/service/shutdown"
	"a.yandex-team.ru/travel/library/go/logging"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
)

type Config struct {
	EnvType                    string `config:"YENV_TYPE,required" yaml:"yenv_type"`
	Logging                    logging.Config
	Shutdown                   shutdown.Config
	Readiness                  readiness.Config
	Dicts                      dicts.Config
	DynamicResources           dynamicresources.Config `yaml:"dynamic_resources"`
	HealthCheck                HealthCheckConfig
	Metrics                    metricsserver.MetricsConfig
	QIDConsumer                qidconsumer.Config        `yaml:"qid_consumer"`
	SearchResultsCache         searchresultscache.Config `yaml:"search_results_cache"`
	SearchResultsQueueProducer queueproducer.Config      `yaml:"search_results_queue_producer"`
	Profiling                  profiling.Config
	DryRun                     bool `config:"DRY_RUN" yaml:"dry_run"`
}

func (c Config) IsDevelopment() bool {
	return c.EnvType == "development"
}

func (c Config) IsTesting() bool {
	return c.EnvType == "testing"
}

type HealthCheckConfig struct {
	UpdateInterval time.Duration `config:"HEALTH_CHECK_UPDATE_INTERVAL" yaml:"update_interval"`
}

var (
	DefaultHealthCheckConfig = HealthCheckConfig{
		UpdateInterval: 1 * time.Second,
	}

	DefaultMetricsConfig = metricsserver.MetricsConfig{
		Addr:                       "[::]:8383",
		PerfMetricsRefreshInterval: 5 * time.Second,
		PerfMetricsPrefix:          "perf",
	}

	Cfg = Config{
		EnvType:                    "development",
		Logging:                    logging.DefaultConfig,
		Shutdown:                   shutdown.DefaultConfig,
		Readiness:                  readiness.DefaultConfig,
		Dicts:                      dicts.DefaultConfig,
		DynamicResources:           dynamicresources.DefaultConfig,
		Metrics:                    DefaultMetricsConfig,
		HealthCheck:                DefaultHealthCheckConfig,
		QIDConsumer:                qidconsumer.DefaultConfig,
		SearchResultsCache:         searchresultscache.DefaultConfig,
		SearchResultsQueueProducer: queueproducer.DefaultConfig,
		Profiling:                  profiling.DefaultConfig,
		DryRun:                     false,
	}
)
