package logbroker

import (
	"math/rand"
	"os"
	"strconv"
	"strings"
	"time"
)

func GetDeploySourceID(producerID string) string {
	stage := getEnvOrDefault("DEPLOY_STAGE_ID", "avia-search-results-queue-producer-development")
	unit := getEnvOrDefault("DEPLOY_UNIT_ID", "unit")
	box := getEnvOrDefault("DEPLOY_BOX_ID", "box")
	pod := getEnvOrDefault("DEPLOY_POD_ID", "pod")
	randSource := rand.NewSource(time.Now().UnixNano())
	randGenerator := rand.New(randSource)
	randomPart := strconv.Itoa(randGenerator.Intn(10000000))
	return strings.Join([]string{stage, unit, box, pod, producerID, randomPart}, ".")
}

func getEnvOrDefault(key, defaultValue string) string {
	value := os.Getenv(key)
	if value == "" {
		return defaultValue
	}
	return value
}
