package searchresultscache

import (
	"context"
	"time"

	"a.yandex-team.ru/kikimr/public/sdk/go/ydb"
	"a.yandex-team.ru/kikimr/public/sdk/go/ydb/table"
)

func GetSessionPool(ctx context.Context, config Config) (*table.SessionPool, error) {
	driver, err := ydb.Dial(
		ctx, config.Cluster, &ydb.DriverConfig{
			Database: config.Database,
			Credentials: ydb.AuthTokenCredentials{
				AuthToken: config.Token,
			},
		},
	)
	if err != nil {
		return nil, err
	}
	tableClient := table.Client{
		Driver: driver,
	}

	return &table.SessionPool{
		SizeLimit:          -1,           // No limits for pool size.
		KeepAliveBatchSize: -1,           // Keep alive as much as possible number of sessions.
		IdleThreshold:      time.Second,  // Keep alive idle session every second.
		Builder:            &tableClient, // Create new sessions within tableClient.
	}, nil
}
