package searchresultscache

type Variants struct {
	QueryTime        float64            `json:"query_time"`
	Created          int                `json:"created"`
	AllVariantsCount int                `json:"all_variants_count"`
	Qid              string             `json:"qid"`
	Flights          map[string]*Flight `json:"flights"`
	Expire           int                `json:"expire"`
	Fares            map[string]Fare    `json:"fares"`
}

type Flight struct {
	Arrival       Time   `json:"arrival"`
	To            int    `json:"to"`
	CompanyTariff int    `json:"companyTariff"`
	From          int    `json:"from"`
	Key           string `json:"key"`
	Company       int    `json:"company"`
	AviaCompany   int    `json:"aviaCompany"`
	Number        string `json:"number"`
	Departure     Time   `json:"departure"`
}

type Time struct {
	Local  string `json:"local"`
	Tzname string `json:"tzname"`
	Offset int    `json:"offset"`
}

type Fare struct {
	Baggage       [][]string `json:"baggage"`
	Charter       *bool      `json:"charter"`
	Selfconnect   bool       `json:"selfconnect"`
	PriceCategory string     `json:"price_category"`
	Expire        int        `json:"expire"`
	Created       int        `json:"created"`
	FareCodes     [][]string `json:"fare_codes"`
	Route         [][]string `json:"route"`
	Tariff        Tariff     `json:"tariff"`
}

type Tariff struct {
	Currency string  `json:"currency"`
	Value    float64 `json:"value"`
}

type Meta struct {
	Expire int64 `json:"expire"`
}
