package dynamicresources

import (
	"encoding/json"
	"net/http"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/httputil/headers"
)

type Config struct {
	Addr  string
	Route string
}

var DefaultConfig = Config{
	Addr:  "[::]:9006",
	Route: "/update_dicts",
}

type Service struct {
	logger   log.Logger
	onUpdate func() error
	config   Config
}

func NewService(logger log.Logger, config Config, onUpdate func() error) *Service {
	return &Service{logger: logger.WithName("DynamicResorucesService"), config: config, onUpdate: onUpdate}
}

func (s *Service) BackroundRun() {
	router := chi.NewRouter()
	router.Get(s.config.Route, s.updateHandler)
	go func() {
		_ = http.ListenAndServe(s.config.Addr, router)
	}()
}

type updateResourcesResponse struct {
	Status string `json:"status"`
	Error  string `json:"error,omitempty"`
}

var successResponse, _ = json.Marshal(updateResourcesResponse{Status: "success"})

func (s *Service) updateHandler(w http.ResponseWriter, r *http.Request) {
	w.WriteHeader(http.StatusOK)
	w.Header().Set(headers.ContentTypeKey, headers.TypeApplicationJSON.String())
	if err := s.onUpdate(); err == nil {
		_, _ = w.Write(successResponse)
	} else {
		s.logger.Error("failed to update dynamic resources", log.Error(err))
		response, _ := json.Marshal(updateResourcesResponse{Status: "failed", Error: err.Error()})
		_, _ = w.Write(response)
	}
}
