package qidconsumer

type TopicConfig struct {
	Topic               string `yaml:"topic"`
	Consumer            string `yaml:"consumer"`
	MaxReadSize         uint32 `yaml:"max_read_size"`
	MaxReadMessageCount uint32 `yaml:"max_read_messages_count"`
}

type Config struct {
	Token              string      `config:"LOGBROKER_TOKEN,required" yaml:"token"`
	ProcessedQIDTopic  TopicConfig `yaml:"processed_qid_topic"`
	ReadEndpoints      []string    `yaml:"read_endpoints"`
	Disabled           bool        `config:"QID_CONSUMER_DISABLED" yaml:"disabled"`
	MinActiveConsumers int32       `config:"MIN_ACTIVE_CONSUMERS" yaml:"min_active_consumers"`
}

var DefaultConfig = Config{
	ReadEndpoints: []string{
		"sas.logbroker.yandex.net",
		"vla.logbroker.yandex.net",
		"iva.logbroker.yandex.net",
	},
	ProcessedQIDTopic: TopicConfig{
		Topic:               "/avia/testing/ticket-daemon/processed-qid",
		Consumer:            "/avia/testing/search-results-queue-producer/processed-qid-consumer",
		MaxReadSize:         1024 * 1024 * 8,
		MaxReadMessageCount: 5,
	},
	Disabled:           false,
	MinActiveConsumers: 3,
}
