package qidparser

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/library/go/searchcontext"
	"a.yandex-team.ru/travel/library/go/metrics"
)

type Parser struct {
	logger log.Logger
}

func NewParser(logger log.Logger) *Parser {
	return &Parser{logger: logger}
}

func (p *Parser) Parse(rawQIDsChan <-chan string, qidsChan chan<- searchcontext.QID) {
	go func() {
		for rawQID := range rawQIDsChan {
			if qid, err := searchcontext.ParseQID(rawQID); err != nil {
				sendMetric("error")
				p.logger.Warn("failed to parse QID", log.Error(err), log.String("rawQID", rawQID))
			} else {
				sendMetric("success")
				qidsChan <- qid
			}
		}
	}()
}

func sendMetric(status string) {
	metrics.GlobalAppMetrics().GetOrCreateCounter(
		qidParserMetricsPrefix,
		map[string]string{"status": status},
		qidsMetricName,
	).Inc()
}
