package readiness

import (
	"encoding/json"
	"net/http"
	"time"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/library/go/httputil/headers"
)

type Config struct {
	Addr    string
	Route   string
	Timeout time.Duration
}

var DefaultConfig = Config{
	Addr:    "[::]:9003",
	Route:   "/readiness",
	Timeout: 5 * time.Second,
}

type Service struct {
	onReadiness func() bool
	config      Config
}

func NewService(config Config, onReadiness func() bool) *Service {
	return &Service{config: config, onReadiness: onReadiness}
}

func (s *Service) BackroundRun() {
	router := chi.NewRouter()
	router.Get(s.config.Route, s.readinessHandler)
	go func() {
		_ = http.ListenAndServe(s.config.Addr, router)
	}()
}

type readinessResponse struct {
	Status string `json:"status"`
}

var readyResponse, _ = json.Marshal(readinessResponse{"ready"})
var notReadyResponse, _ = json.Marshal(readinessResponse{"not ready"})

func (s *Service) readinessHandler(w http.ResponseWriter, r *http.Request) {
	w.WriteHeader(http.StatusOK)
	w.Header().Set(headers.ContentTypeKey, headers.TypeApplicationJSON.String())
	if s.onReadiness() {
		_, _ = w.Write(readyResponse)
	} else {
		_, _ = w.Write(notReadyResponse)
	}
}
