import logging

import flask_sqlalchemy
import sqlalchemy.exc
import sqlalchemy.orm
import ujson


def items(o):
    return {str(k): str(v) for k, v in o.items()}


def ping_handler(
    app,
    engine: flask_sqlalchemy.SQLAlchemy,
    scoped_session: sqlalchemy.orm.scoping.scoped_session,
    signalling_session,
):
    @app.route('/ping')
    def ping():
        db_working = False
        try:
            result = engine.engine.execute('SELECT 1,2,3')
            check_row = next(iter(result))

            if check_row == (1, 2, 3):
                db_working = True
            else:
                db_working = False
                logging.error('DB not working. %s', check_row)
        except sqlalchemy.exc.SQLAlchemyError:
            db_working = False
            logging.exception('DB not working. That\'s exceptional!')

        status = 200 if db_working else 500

        return (
            ujson.dumps({
                'engine': items(engine.__dict__),
                'session_factory': items(scoped_session.__dict__),
                'session': items(signalling_session.__dict__),
                'db_ok': db_working,
            }, indent=4),
            status,
            {'Content-type': 'application/json'},
        )
