from flask import request, render_template
from flask_admin.contrib.sqla import ModelView

from travel.avia.shared_flights.admin.app.parsers.apm_parser import ApmParser


class ApmUploadView(ModelView):
    can_edit = False
    can_delete = False
    create_template = 'apm_upload.html'
    column_default_sort = ('imported_date', True)


def apm_upload_handler(app, config):
    @app.route('/admin/upload-apm', methods=['POST'])
    def upload_file():
        if request.method == 'POST':
            apm_file = request.files['apm']
            apm_parser = ApmParser()
            data = apm_parser.parse(apm_file, config, request.form.get("memo"))
            return render_template("apm_upload_result.html", data=data)
