from flask_admin.contrib.sqla import ModelView
from flask_admin.form import rules
from wtforms import DateField, DateTimeField, validators


DATE_FORMAT = '%Y-%m-%d'
DATETIME_FORMAT = '%Y-%m-%d %H:%M:%S'
OPTIONAL_VALIDATORS = (validators.Optional(),)


class BlacklistView(ModelView):
    form_ajax_refs = {
        'station_from': {
            'fields': ('title_default', 'popular_title_default', 'iata'),
            'page_size': 10,
        },
        'station_to': {
            'fields': ('title_default', 'popular_title_default', 'iata'),
            'page_size': 10,
        },
    }
    form_widget_args = {
        'created_at': {
            'disabled': True,
        },
        'updated_at': {
            'disabled': True,
        },
    }

    form_rules = [
        rules.FieldSet(('country_from_id', 'settlement_from_id', 'station_from',), 'From'),
        rules.FieldSet(('country_to_id', 'settlement_to_id', 'station_to',), 'To'),

        rules.Header('Flight'),
        rules.Field('carrier'),
        rules.Field('flight_number'),
        rules.HTML(
        '''
        <div style=\"padding-left: 25ex;\">
        Only one flight dates range per flight is currently supported.<br/>
        If more than one set of ban dates is applicable to the same flight,
        then only dates from the first matching rule are used.
        </div>
        '''
        ),
        rules.Field('flight_date_from'),
        rules.Field('flight_date_to'),
        rules.Field('national_version'),
        rules.Field('language'),
        rules.Field('source'),

        rules.Header('Admin'),
        rules.Field('reason'),
        rules.FieldSet(('force', 'active_since', 'active_until'), 'On/off'),

        rules.FieldSet(('created_at', 'updated_at'), 'Meta'),
    ]

    def get_form(self):
        edit_form = super(ModelView, self).get_form()
        edit_form.flight_date_from = DateField('Flight Date From', format=DATE_FORMAT, validators=OPTIONAL_VALIDATORS)
        edit_form.flight_date_to = DateField('Flight Date To', format=DATE_FORMAT, validators=OPTIONAL_VALIDATORS)
        edit_form.active_since = DateTimeField('Active Since', format=DATETIME_FORMAT, validators=OPTIONAL_VALIDATORS)
        edit_form.active_until = DateTimeField('Active Until', format=DATETIME_FORMAT, validators=OPTIONAL_VALIDATORS)
        return edit_form


class BlacklistHistoryView(ModelView):
    can_edit = False
    can_create = False
    can_export = False
    can_view_details = True
    can_delete = False
