from flask_admin.contrib.sqla import ModelView
from flask_admin.form import rules


class FlightMergeRuleView(ModelView):

    column_labels = dict(
        id='ID',
        operating_carrier='Operating',
        operating_flight_number_regex='Flight',
        marketing_carrier='Marketing',
        marketing_flight_number_regex='Flight',
        excluded_carrier='Excluded Carrier',
        should_merge='Merge',
        is_rule_active='Active',
        comment='Comment',
        updated_at='Updated',
    )

    column_list = [
        'id',
        'operating_carrier',
        'operating_flight_number_regex',
        'marketing_carrier',
        'marketing_flight_number_regex',
        'excluded_carrier',
        'should_merge',
        'is_rule_active',
        'comment',
        'updated_at',
    ]

    form_ajax_refs = {
        'operating_carrier': {
            'fields': ('id', 'iata', 'sirena_id', 'icao', 'title'),
            'page_size': 10,
        },
        'marketing_carrier': {
            'fields': ('id', 'iata', 'sirena_id', 'icao', 'title'),
            'page_size': 10,
        },
        'excluded_carrier': {
            'fields': ('id', 'iata', 'sirena_id', 'icao', 'title'),
            'page_size': 10,
        },
    }
    form_widget_args = {
        'updated_at': {
            'disabled': True,
        },
    }

    form_rules = [
        rules.FieldSet(('operating_carrier', 'operating_flight_number_regex',), 'Operating Flight'),
        rules.FieldSet(('marketing_carrier', 'marketing_flight_number_regex',), 'Marketing Flight'),

        rules.Field('excluded_carrier'),
        rules.Field('should_merge'),
        rules.Field('is_rule_active'),
        rules.Field('comment'),
        rules.Field('updated_at'),
    ]
