from flask_admin.contrib.sqla import ModelView
from flask_admin.form import rules


class IataCorrectionView(ModelView):
    form_widget_args = {
        'created_at': {
            'disabled': True,
        },
        'updated_at': {
            'disabled': True,
        },
    }

    form_rules = [
        rules.Header('Selection criteria'),
        rules.Field('marketing_carrier_iata'),
        rules.Field('carrier_sirena'),
        rules.Field('flight_number_regex'),

        rules.Field('designated_carrier'),
        rules.Field('flying_carrier_iata'),

        rules.Field('priority'),

        rules.Header('Result'),
        rules.Field('carrier_id'),

        rules.FieldSet(('created_at', 'updated_at'), 'Meta'),
    ]


class IataCorrectionHistoryView(ModelView):
    can_edit = False
    can_create = False
    can_export = False
    can_view_details = True
    can_delete = False
