from flask_admin.contrib.sqla import ModelView
from flask_admin.form import rules


class StationStatusSourceView(ModelView):
    can_edit = False
    column_editable_list = ('whitelist', 'blacklist', 'trusted')
    column_sortable_list = [('station', 'station.id'), ('status_source', 'status_source.priority')]
    column_default_sort = [('station.id', True), ('status_source.priority', False)]

    form_ajax_refs = {
        'station': {
            'fields': ('id', 'title_default', 'iata', 'icao', 'sirena'),
            'page_size': 10,
        },
        'status_source': {
            'fields': ('id', 'name'),
            'page_size': 10,
        },
    }

    form_rules = [
        rules.Field('station'),
        rules.Field('status_source'),
        rules.Field('whitelist'),
        rules.Field('blacklist'),
        rules.Field('trusted'),
    ]


class StationStatusSourceHistoryView(ModelView):
    can_edit = False
    can_create = False
    can_export = False
    can_view_details = True
    can_delete = False
