from flask_admin.contrib.sqla import ModelView
from flask_admin.form import rules


class StopPointView(ModelView):
    can_create = False

    column_list = ('station_id', 'station', 'station_code', 'city_code', 'leg_key', 'unknown_since')

    column_searchable_list = ('station_code', 'city_code', 'station_id')

    column_sortable_list = ('station_code', 'city_code', 'station_id')

    column_filters = ('station_code', 'city_code', 'station_id')

    form_ajax_refs = {
        'station': {
            'fields': ('title_default', 'popular_title_default', 'iata', 'id'),
            'page_size': 10,
        },
    }

    form_widget_args = {
        'station_id': {
            'readonly': True,
        },
        'unknown_since': {
            'readonly': True,
        },
        'leg_key': {
            'readonly': True,
        },
    }

    form_rules = [
        rules.Header('Selection criteria'),
        rules.Field('station_code'),
        rules.Field('city_code'),

        rules.Header('Result'),
        rules.Field('station'),

        rules.FieldSet(('unknown_since', 'leg_key'), 'Meta'),
    ]
