# -*- coding: utf-8 -*-
import os
import re
import sys

from alembic.config import CommandLine

from travel.library.python.resource import extract_resources


def _patch_cli(cli: CommandLine) -> CommandLine:
    cli.parser.description = '''
    ARCADIA: By default resources in alembic binary extract to current directory
    To change extract directory pass TRAVEL_MIGRATIONS_EXTRACT_DIR environment variable
    '''

    return cli


def _main():
    extract_resources(
        'travel/avia/shared_flights/alembic/',
        base_path=os.environ.get('TRAVEL_MIGRATIONS_EXTRACT_DIR', None)
    )

    sys.argv[0] = re.sub(r'(-script\.pyw?|\.exe)?$', '', sys.argv[0])
    cli = _patch_cli(CommandLine())
    sys.exit(cli.main())


if __name__ == '__main__':
    _main()
