"""Change flight status primary key

Revision ID: 63c789b12971
Revises:
Create Date: 2020-08-13 08:21:33.794229+00:00

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '63c789b12971'
down_revision = '883e0d84c636'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('flight_status', sa.Column('routepointfrom', sa.String(), server_default='', nullable=False))
    op.add_column('flight_status', sa.Column('routepointto', sa.String(), server_default='', nullable=False))
    op.execute("""UPDATE flight_status
    set airlinecode = (
        SELECT iata
    from carrier
    WHERE carrier.id = flight_status.airlineid
    )
    WHERE airlinecode is null \
          or airlinecode = '';
    """)
    op.execute("""UPDATE flight_status
set airlinecode = (
    SELECT sirena_id
    from carrier
    WHERE carrier.id = flight_status.airlineid
)
WHERE airlinecode is null
   or airlinecode = '';""")
    op.execute("""UPDATE flight_status
set airlinecode = (
    SELECT icao
    from carrier
    WHERE carrier.id = flight_status.airlineid
)
WHERE airlinecode is null
   or airlinecode = '';
""")
    op.execute("""UPDATE flight_status
set airlinecode = (
    SELECT icao_ru
    from carrier
    WHERE carrier.id = flight_status.airlineid
)
WHERE airlinecode is null
   or airlinecode = '';
""")
    op.execute("""DELETE
FROM flight_status
WHERE airlinecode IS NULL
   or airlinecode = '';""")
    # DELETE flight statuses that has dups with different airline id and its airline id not in carriers table
    op.execute("""DELETE
FROM flight_status
WHERE (airlinecode, flightnumber, legnumber, flightdate, statussourceid) IN (
    SELECT airlinecode, flightnumber, legnumber, flightdate, statussourceid
    FROM flight_status
    GROUP BY airlinecode, flightnumber, legnumber, flightdate, statussourceid
    HAVING COUNT(*) > 1
       AND MIN(airlineid) <> MAX(airlineid)
)
  AND airlineid NOT IN (SELECT id from carrier);""")
    # DELETE flight statuses that has duplicates and carrier code doesn't match with existing carrier table;
    op.execute("""DELETE
FROM flight_status
WHERE (airlinecode, airlineid, flightnumber, legnumber, flightdate, statussourceid) IN (
    SELECT airlinecode, airlineid, flightnumber, legnumber, flightdate, statussourceid
    from flight_status
             INNER JOIN carrier ON carrier.id = airlineid
    WHERE (airlinecode, flightnumber, legnumber, flightdate, statussourceid) IN (
        SELECT airlinecode, flightnumber, legnumber, flightdate, statussourceid
        FROM flight_status
        GROUP BY airlinecode, flightnumber, legnumber, flightdate, statussourceid
        HAVING COUNT(*) > 1
           AND MIN(airlineid) <> MAX(airlineid)
    )
      AND airlineid <> 0
      AND carrier.iata <> airlinecode
      AND carrier.sirena_id <> airlinecode
      AND carrier.icao <> airlinecode
      AND carrier.icao_ru <> airlinecode
)""")
    # DELETE statuses that has duplicate with a different id. Delete with a max id
    op.execute("""DELETE
FROM flight_status
WHERE (airlinecode, flightnumber, legnumber, flightdate, statussourceid, airlineid) IN
      (
          SELECT airlinecode, flightnumber, legnumber, flightdate, statussourceid, MAX(airlineid) as airlineid
          FROM flight_status
          GROUP BY airlinecode, flightnumber, legnumber, flightdate, statussourceid
          HAVING COUNT(*) > 1
             AND MIN(airlineid) <> MAX(airlineid)
          ORDER BY airlinecode, flightnumber, legnumber, flightdate, statussourceid
      )""")
    op.alter_column('flight_status', 'airlinecode',
                    existing_type=sa.VARCHAR(),
                    nullable=False)
    op.drop_constraint('flight_status_pk', 'flight_status', type_='primary')
    op.create_primary_key(
        'flight_status_pk', 'flight_status',
        ['airlinecode', 'flightnumber', 'legnumber', 'flightdate', 'statussourceid'],
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('flight_status_pk', 'flight_status', type='primary')
    op.create_primary_key(
        'flight_status_pk', 'flight_status',
        ['airlineid', 'flightnumber', 'legnumber', 'flightdate', 'statussourceid'],
    )
    op.drop_column('flight_status', 'routepointto')
    op.drop_column('flight_status', 'routepointfrom')
    op.drop_constraint('flight_status_pk', 'flight_status', type_='primary')
    op.create_primary_key(
        'flight_status_pk', 'flight_status',
        ['airlineid', 'flightnumber', 'legnumber', 'flightdate', 'statussourceid'],
    )
    # ### end Alembic commands ###
