"""last month flights

Revision ID: 69b0c63b7339
Revises: 399c49cab8a1
Create Date: 2020-09-29 04:25:31.774647+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '69b0c63b7339'
down_revision = '399c49cab8a1'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('existing_flight_base',
    sa.Column('id', sa.Integer(), autoincrement=False, nullable=False),
    sa.Column('operating_carrier', sa.BigInteger(), nullable=False),
    sa.Column('operating_carrier_iata', sa.String(), nullable=True),
    sa.Column('operating_flight_number', sa.String(), nullable=False),
    sa.Column('leg_seq_number', sa.Integer(), nullable=False),
    sa.Column('departure_station', sa.BigInteger(), nullable=False),
    sa.Column('departure_station_iata', sa.String(), nullable=True),
    sa.Column('scheduled_departure_time', sa.Integer(), nullable=False),
    sa.Column('departure_terminal', sa.String(), nullable=True),
    sa.Column('arrival_station', sa.BigInteger(), nullable=False),
    sa.Column('arrival_station_iata', sa.String(), nullable=True),
    sa.Column('scheduled_arrival_time', sa.Integer(), nullable=False),
    sa.Column('arrival_terminal', sa.String(), nullable=True),
    sa.Column('aircraft_model', sa.String(), nullable=True),
    sa.Column('flying_carrier_iata', sa.String(), nullable=True),
    sa.Column('intl_dom_status', sa.String(), nullable=True),
    sa.Column('traffic_restriction_code', sa.String(), nullable=True),
    sa.Column('designated_carrier', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('source', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('id', 'source')
    )
    op.create_table('existing_flight_pattern',
    sa.Column('flight_departure_day', sa.Date(), nullable=False),
    sa.Column('marketing_carrier', sa.BigInteger(), nullable=False),
    sa.Column('marketing_flight_number', sa.String(), nullable=False),
    sa.Column('leg_seq_number', sa.Integer(), nullable=False),
    sa.Column('source', sa.Integer(), nullable=False),
    sa.Column('flight_base_id', sa.Integer(), nullable=False),
    sa.Column('marketing_carrier_iata', sa.String(), nullable=True),
    sa.Column('is_administrative', sa.Boolean(), nullable=False),
    sa.Column('is_codeshare', sa.Boolean(), nullable=False),
    sa.Column('arrival_day_shift', sa.Integer(), nullable=False),
    sa.Column('designated_carrier', sa.Integer(), server_default='0', nullable=True),
    sa.Column('departure_day_shift', sa.Integer(), server_default='0', nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('flight_departure_day', 'marketing_carrier', 'marketing_flight_number', 'leg_seq_number', 'source')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('existing_flight_pattern')
    op.drop_table('existing_flight_base')
    # ### end Alembic commands ###
