package main

import (
	"time"

	aviaHandlers "a.yandex-team.ru/travel/avia/library/go/handlers"
	aviaMetrics "a.yandex-team.ru/travel/avia/library/go/metrics"
)

func configureMetrics() {
	metricsRegistry := aviaMetrics.NewAppMetricsRegistry("")
	sharedFlightMetrics := aviaMetrics.NewMetricsStorage(metricsRegistry)
	aviaMetrics.SetGlobalMetrics(sharedFlightMetrics)

	handler := aviaHandlers.NewAppMetricsHandler(metricsRegistry)
	perfMetricsHandler := aviaHandlers.NewPerfMetricsHandler("perf", 5*time.Second)

	go runChiServer(MetricsPort, handler, perfMetricsHandler)
}
