package main

import (
	"os"

	"a.yandex-team.ru/library/go/core/log"
	aviaMetrics "a.yandex-team.ru/travel/avia/library/go/metrics"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/config"
	loadSnapshotServices "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/loadsnapshot"
	storageServices "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

func main() {
	err := run()
	if err != nil {
		os.Exit(1)
	}
}

func run() error {
	defer func() {
		_ = logger.Logger().L.Sync()
	}()
	configuration := config.NewConfig()
	configureMetrics()

	storageService := storageServices.NewStorageService(storage.NewStorage())

	loadSnapshotService := loadSnapshotServices.NewLoadSnapshotService(storageService, configuration)

	loadResult, err := loadSnapshotService.LoadSnapshot("", "", false)
	if err != nil {
		logger.Logger().Error("Cannot load snapshot", log.Error(err))
		return err
	}
	logger.Logger().Info("loaded", log.Reflect("loadResult", loadResult))

	DumpYt(storageService.Instance())
	return nil
}

func configureMetrics() {
	metricsRegistry := aviaMetrics.NewAppMetricsRegistry("")
	sharedFlightMetrics := aviaMetrics.NewMetricsStorage(metricsRegistry)
	aviaMetrics.SetGlobalMetrics(sharedFlightMetrics)
}
