package handlers

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flight"
)

func ConvertFlightToText(segment *flight.FlightSegment) string {
	var lines []string
	if len(segment.Segments) == 0 {
		lines = append(lines, convertSegmentToText(segment, ""))
	} else {
		for _, leg := range segment.Segments {
			lines = append(lines, convertSegmentToText(leg, "#"))
		}
	}
	return strings.Join(lines, "\n")
}

func ConvertFlightsToText(segments []*flight.FlightSegment) string {
	var lines []string
	for _, segment := range segments {
		lines = append(lines, ConvertFlightToText(segment))
		lines = append(lines, "---")
	}
	return strings.Join(lines, "\n")
}

func ConvertFlightsMapToText(segmentsMap map[int32][]*flight.FlightSegment) string {
	var lines []string
	for carrier, segments := range segmentsMap {
		lines = append(lines, fmt.Sprintf("--- carrier %d ---", carrier))
		for _, segment := range segments {
			lines = append(lines, ConvertFlightToText(segment))
			lines = append(lines, "---")
		}
	}
	return strings.Join(lines, "\n")
}

func convertSegmentToText(segment *flight.FlightSegment, prefix string) string {
	return fmt.Sprintf("%v %v %v %v %v %v %v %v %v %v %v %v",
		prefix,
		segment.CompanyIata,
		segment.Number,
		segment.AirportFromIata,
		segment.DepartureDay,
		segment.DepartureTime,
		segment.AirportToIata,
		segment.ArrivalDay,
		segment.ArrivalTime,
		segment.Source,
		segment.Title,
		segment.Banned,
	)
}
