package handlers

import (
	"fmt"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/utils"
)

type flightP2PSegmentInfoHandler struct {
	service *storage.Service
}

func (h *flightP2PSegmentInfoHandler) Handle(c echo.Context) error {
	service := h.service.Instance()

	form := FlightP2PScheduleForm{}
	if err := form.Fill(c, service, true); err.Error != nil {
		return c.JSON(err.HTTPCode, err.Error.Error())
	}
	if err := form.Validate(); err != nil {
		return c.JSON(http.StatusBadRequest, err.Error())
	}
	value, storageErr := service.GetFlightP2PSegmentInfo(
		form.departFrom, form.arriveTo, form.nationalVersion, form.showBanned, form.debug)

	if storageErr != nil {
		if httpErr, ok := storageErr.(*utils.ErrorWithHTTPCode); ok {
			return c.JSON(httpErr.HTTPCode, fmt.Sprintf("%v", httpErr))
		}
		return c.JSON(http.StatusInternalServerError, fmt.Sprintf("%v", storageErr))
	}

	return c.JSON(http.StatusOK, value)
}

func (h *flightP2PSegmentInfoHandler) GetRoute() string {
	return "/flight-p2p-segment-info/"
}

func NewFlightP2PSegmentInfoHandler(service *storage.Service) *flightP2PSegmentInfoHandler {
	return &flightP2PSegmentInfoHandler{
		service: service,
	}
}
