package handlers

import (
	"fmt"
	"net/http"
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/utils"
)

type flightP2PSummaryHandler struct {
	service *storage.Service
}

func (h *flightP2PSummaryHandler) Handle(c echo.Context) error {
	debug := strings.EqualFold(c.QueryParam("debug"), "true")

	value, storageErr := h.service.Instance().GetFlightsP2PSummary(debug)

	if storageErr != nil {
		if httpErr, ok := storageErr.(*utils.ErrorWithHTTPCode); ok {
			return c.JSON(httpErr.HTTPCode, fmt.Sprintf("%v", httpErr))
		}
		return c.JSON(http.StatusInternalServerError, fmt.Sprintf("%v", storageErr))
	}

	return c.JSON(http.StatusOK, value)
}

func (h *flightP2PSummaryHandler) GetRoute() string {
	return "/flight-p2p-summary/"
}

func NewFlightP2PSummaryHandler(service *storage.Service) *flightP2PSummaryHandler {
	return &flightP2PSummaryHandler{
		service: service,
	}
}
