package handlers

import (
	"fmt"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/utils"
)

type FlightRangeMultiHanlder struct {
	service *storage.Service
}

func (h *FlightRangeMultiHanlder) Handle(c echo.Context) error {
	form, formErr := newFlightRangeFormParser().FillForm(c, false)
	if formErr != nil {
		if httpErr, ok := formErr.(*utils.ErrorWithHTTPCode); ok {
			return c.JSON(httpErr.HTTPCode, fmt.Sprintf("%v", httpErr))
		}
		return c.JSON(http.StatusInternalServerError, fmt.Sprintf("%v", formErr))
	}

	value, storageErr := h.service.Instance().GetFlightRangeMulti(
		form.FlightNumber,
		form.NationalVersion,
		form.ShowBanned,
		form.PseudoNow,
		form.LimitBefore,
		form.LimitAfter,
		form.Direction,
		form.ReferenceTime,
	)

	if storageErr != nil {
		if httpErr, ok := storageErr.(*utils.ErrorWithHTTPCode); ok {
			return c.JSON(httpErr.HTTPCode, fmt.Sprintf("%v", httpErr))
		}
		return c.JSON(http.StatusInternalServerError, fmt.Sprintf("%v", storageErr))
	}

	if form.TextFormat {
		return c.String(http.StatusOK, ConvertFlightsMapToText(value))
	}

	return c.JSON(http.StatusOK, value)
}

func (h *FlightRangeMultiHanlder) GetRoute() string {
	return "/flight-range-multi/:flight/"
}

func NewFlightRangeMultiHandler(service *storage.Service) *FlightRangeMultiHanlder {
	return &FlightRangeMultiHanlder{
		service: service,
	}
}
