package handlers

import (
	"fmt"
	"net/http"
	"time"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/utils"
)

type flightStationHandler struct {
	service    *storage.Service
	formParser FlightBoardFormParser
}

func (h *flightStationHandler) Handle(c echo.Context) error {

	form, formErr := h.formParser.FillForm(c)
	if formErr != nil {
		if httpErr, ok := formErr.(*utils.ErrorWithHTTPCode); ok {
			return c.JSON(httpErr.HTTPCode, fmt.Sprintf("%v", httpErr))
		}
		return c.JSON(http.StatusInternalServerError, fmt.Sprintf("%v", formErr))
	}

	value, storageErr := h.service.Instance().GetStationFlights(
		form.station,
		form.after,
		form.before,
		form.limit,
		form.sortAscending,
		form.direction,
		form.terminal,
		form.nationalVersion,
		time.Now(),
	)

	if storageErr != nil {
		if httpErr, ok := storageErr.(*utils.ErrorWithHTTPCode); ok {
			return c.JSON(httpErr.HTTPCode, fmt.Sprintf("%v", httpErr))
		}
		return c.JSON(http.StatusInternalServerError, fmt.Sprintf("%v", storageErr))
	}

	return c.JSON(http.StatusOK, value)
}

func (h *flightStationHandler) GetRoute() string {
	return "/flight-station/:station/"
}

func NewFlightStationHandler(service *storage.Service) *flightStationHandler {
	return &flightStationHandler{
		service:    service,
		formParser: NewFlightBoardHandler(service),
	}
}
