package handlers

import (
	"fmt"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/utils"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/httputil"
)

type flightsNetworkHandler struct {
	service *storage.Service
}

func (h *flightsNetworkHandler) Handle(c echo.Context) error {
	params := c.QueryParams()
	carriers := params["carrier"]
	if len(carriers) == 0 {
		return c.JSON(http.StatusBadRequest, "carrier parameter is missing")
	}

	unescapedCarriers := make([]string, 0, len(carriers))
	for _, c := range carriers {
		unescapedCarriers = append(unescapedCarriers, httputil.Unescape(c))
	}

	value, err := h.service.Instance().GetFlightsNetwork(unescapedCarriers)

	if err != nil {
		if httpErr, ok := err.(*utils.ErrorWithHTTPCode); ok {
			return c.JSON(httpErr.HTTPCode, fmt.Sprintf("%v", httpErr))
		}
		return c.JSON(http.StatusInternalServerError, fmt.Sprintf("%v", err))
	}

	return c.JSON(http.StatusOK, value)
}

func (h *flightsNetworkHandler) GetRoute() string {
	return "/flights-network/"
}

func NewFlightsNetworkHandler(service *storage.Service) *flightsNetworkHandler {
	return &flightsNetworkHandler{
		service: service,
	}
}
