package lib

import (
	"strconv"
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/proto/shared_flights/snapshots"
)

type StationProvider interface {
	ByID(id int64) (*snapshots.TStationWithCodes, bool)
	ByIata(code string) (*snapshots.TStationWithCodes, bool)
	BySirena(code string) (*snapshots.TStationWithCodes, bool)
	ByIcao(code string) (*snapshots.TStationWithCodes, bool)
}

// TODO(mikhailche): вынести в общую библиотеку, ибо используется в двух ручках
func ParseStation(stationCode string, stations StationProvider) (*snapshots.TStationWithCodes, error) {
	if len(stationCode) == 0 {
		return nil, xerrors.New("parameter is empty")
	}
	var station *snapshots.TStationWithCodes
	var exists bool
	stationID, err := strconv.Atoi(stationCode)
	if err == nil {
		station, exists = stations.ByID(int64(stationID))
		if !exists {
			return nil, xerrors.Errorf("station with id %d doesn't exist", stationID)
		}
		return station, nil
	}
	station, exists = stations.ByIata(stationCode)
	if exists {
		return station, nil
	}
	station, exists = stations.BySirena(stationCode)
	if exists {
		return station, nil
	}
	station, exists = stations.ByIcao(stationCode)
	if exists {
		return station, nil
	}
	if strings.HasPrefix(stationCode, "s") {
		return nil, xerrors.Errorf("station %s doesn't exist; did you mean %s?", stationCode, stationCode[1:])
	} else {
		return nil, xerrors.Errorf("station %s does not exist", stationCode)
	}
}
