package handlers

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/loadsnapshot"
)

type LoadSnapshotHandler struct {
	service loadsnapshot.Service
}

func (h *LoadSnapshotHandler) Handle(c echo.Context) error {
	curBase := c.Param("curBase")
	curDelta := c.Param("curDelta")
	skipBase := false

	// It's more convenient to use "/load-snapshot/delta-only/latest" URL than always specify three parameters
	if curBase == "delta-only" {
		curBase = ""
		skipBase = true
	}

	result, err := h.service.LoadSnapshot(curBase, curDelta, skipBase)
	if err != nil {
		return c.JSON(http.StatusInternalServerError, err.Error())
	}

	return c.JSON(http.StatusOK, result)
}

func (h *LoadSnapshotHandler) GetRoute() string {
	return "/load-snapshot/:curBase/:curDelta/"
}

func NewLoadSnapshotHandler(service loadsnapshot.Service) *LoadSnapshotHandler {
	return &LoadSnapshotHandler{
		service: service,
	}
}
