package handlers

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type PingHandler struct {
	service *storage.Service
}

func (h *PingHandler) Handle(c echo.Context) error {
	err := h.service.Available()
	if err != nil {
		return c.JSON(http.StatusServiceUnavailable, err.Error())
	}

	if h.service.IsShutdown() {
		return c.JSON(http.StatusGone, "service is shutting down")
	}

	return c.JSON(http.StatusOK, "200 OK!")
}

func (h *PingHandler) GetRoute() string {
	return "/ping/"
}

func (h *PingHandler) HandleShutdown(c echo.Context) error {
	logger.Logger().Info("Service is scheduled for shutdown")
	h.service.Shutdown()
	return c.JSON(http.StatusOK, "Shutting down!")
}

func (h *PingHandler) GetShutdownRoute() string {
	return "/shutdown/"
}

func NewPingHandler(service *storage.Service) *PingHandler {
	return &PingHandler{
		service: service,
	}
}
