package handlers

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/config"
)

type slowQueriesHandlerImpl struct {
	handler   Handler
	apiConfig config.APIConfig
}

func (h *slowQueriesHandlerImpl) Handle(c echo.Context) error {
	if !h.apiConfig.AllowSlowQueries {
		return c.JSON(http.StatusBadRequest, "slow queries are not allowed on this instance")
	}
	return h.handler.Handle(c)
}

func (h *slowQueriesHandlerImpl) GetRoute() string {
	return h.handler.GetRoute()
}

func SlowQueriesHandler(handler Handler, apiConfig config.APIConfig) Handler {
	return &slowQueriesHandlerImpl{
		handler:   handler,
		apiConfig: apiConfig,
	}
}
