package logthrottler

import (
	"a.yandex-team.ru/library/go/core/log"
	aviaMetrics "a.yandex-team.ru/travel/avia/library/go/metrics"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/metrics"
	"sync"
	"time"
)

type logTime struct {
	time       time.Time
	relogAfter time.Duration
}

var logTimeByDescriptor = make(map[interface{}]logTime)
var mutex = &sync.RWMutex{}

func LogWithThrottling(
	descriptor interface{},
	relogPeriod time.Duration,
	logFunction func(msg string, fields ...log.Field),
	msg string,
	fields ...log.Field,
) {
	mutex.RLock()
	lastLoggedTime, alreadyLogged := logTimeByDescriptor[descriptor]
	mutex.RUnlock()
	if !alreadyLogged || time.Since(lastLoggedTime.time) > relogPeriod {
		mutex.Lock()
		logTimeByDescriptor[descriptor] = logTime{time.Now(), relogPeriod}
		mutex.Unlock()
		logFunction(msg, fields...)
	}
}

func init() {
	// Metrics to decide if we need a cleaner of some sort
	go func() {
		for range time.Tick(1 * time.Minute) {
			aviaMetrics.
				GlobalMetrics().
				Gauge(metrics.LogThrottlerPrefix, metrics.ThrottlerCacheSize).
				Set(float64(len(logTimeByDescriptor)))
		}
	}()
}
