package metrics

import "a.yandex-team.ru/travel/avia/library/go/metrics"

var (
	LoaderPrefix       metrics.MetricPrefix = "mds_loader"
	LogThrottlerPrefix metrics.MetricPrefix = "log_throttler"

	StorageOk              metrics.MetricName = "storage_ok"
	LoadingBaseSnapshot    metrics.MetricName = "base_loading"
	LoadingDeltaSnapshot   metrics.MetricName = "delta_loading"
	BaseLoadTime           metrics.MetricName = "base_load_time"
	DeltaLoadTime          metrics.MetricName = "delta_load_time"
	TotalLoadTime          metrics.MetricName = "total_load_time"
	BaseTimeSinceLastLoad  metrics.MetricName = "base_time_since_last_load"
	DeltaTimeSinceLastLoad metrics.MetricName = "delta_time_since_last_load"
	FlightBaseCount        metrics.MetricName = "flightbase_count"
	FlightPatternCount     metrics.MetricName = "flightpattern_count"
	FlightStatusCount      metrics.MetricName = "flightstatus_count"
	CarriersCount          metrics.MetricName = "carriers_count"
	StationsCount          metrics.MetricName = "stations_count"
	FlightBaseSize         metrics.MetricName = "flightbase_size"
	FlightPatternSize      metrics.MetricName = "flightpattern_size"
	FlightStatusSize       metrics.MetricName = "flightstatus_size"
	CarriersSize           metrics.MetricName = "carriers_size"
	StationsSize           metrics.MetricName = "stations_size"

	StorageState          metrics.MetricPrefix = "storage_state"
	DeparturesStatusesSVO metrics.MetricName   = "departures_statuses.svo"
	DeparturesStatusesDME metrics.MetricName   = "departures_statuses.dme"
	DeparturesStatusesVKO metrics.MetricName   = "departures_statuses.vko"
	DeparturesStatusesLED metrics.MetricName   = "departures_statuses.led"
	DeparturesSVO         metrics.MetricName   = "departures.svo"
	DeparturesDME         metrics.MetricName   = "departures.dme"
	DeparturesVKO         metrics.MetricName   = "departures.vko"
	DeparturesLED         metrics.MetricName   = "departures.led"
	DeparturesSVX         metrics.MetricName   = "departures.svx"
	DeparturesATL         metrics.MetricName   = "departures.atl"

	ThrottlerCacheSize metrics.MetricName = "cache_size"
)
