package dto

type FlightID struct {
	AirlineID int32  `json:"airlineID"`
	Number    string `json:"number"`
}

type TitledFlight struct {
	FlightID
	Title string `json:"title"`
}

type Route []int64

func (r Route) Equals(r2 Route) bool {
	if len(r) != len(r2) {
		return false
	}
	for i := 0; i < len(r); i++ {
		if r[i] != r2[i] {
			return false
		}
	}
	return true
}

type FlightSource int

const (
	UNKNOWN FlightSource = 0 + iota
	FLIGHTBOARD
	SSIM
	SIRENA
	ADMIN
	end
)

func (source FlightSource) String() string {
	return [...]string{
		"unknown",
		"flight-board",
		"ssim",
		"sirena",
		"admin"}[source]
}
