package format

import (
	dto "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/DTO"
)

type FlightKey struct {
	OperatingCarrier int32
	OperatingFlight  string
}

type Response struct {
	DepartureStations []int32   `json:"departureStations"`
	ArrivalStations   []int32   `json:"arrivalStations"`
	Variants          []Variant `json:"variants"`
}

type Slice struct {
	Flights  []Flight `json:"flights"`
	Duration int      `json:"duration"`
	Banned   string   `json:"banned,omitempty"`
}

func (s *Slice) GetDepartureTimesString() string {
	if len(s.Flights) == 0 {
		return ""
	}
	if len(s.Flights) == 1 {
		return s.Flights[0].DepartureDatetime
	}
	return s.Flights[0].DepartureDatetime + s.Flights[1].DepartureDatetime
}

type Variant struct {
	Forward  Slice  `json:"forward"`
	Backward Slice  `json:"backward,omitempty"`
	Banned   string `json:"banned,omitempty"`
}

func (v *Variant) GetDepartureTimesString() string {
	if len(v.Backward.Flights) == 0 {
		return v.Forward.GetDepartureTimesString()
	}
	return v.Forward.GetDepartureTimesString() + v.Backward.GetDepartureTimesString()
}

type CodeshareFlight struct {
	dto.TitledFlight
}

type Flight struct {
	dto.TitledFlight
	DepartureDatetime string `json:"departureDatetime"` // datetime with timezone 2020-01-05T20:30:35-03:00
	DepartureTerminal string `json:"departureTerminal"`
	DepartureStation  int32  `json:"departureStation"`
	ArrivalDatetime   string `json:"arrivalDatetime"` // datetime with timezone 2020-01-05T20:30:35-03:00
	ArrivalTerminal   string `json:"arrivalTerminal"`
	ArrivalStation    int32  `json:"arrivalStation"`
	TransportModelID  int64  `json:"transportModelID"`
}
