package flight

import (
	"strconv"
)

// Reduces the number of cases when we have to parse a text into a number
type CarrierParam struct {
	carrierText string
	carrierID   int32
}

func NewCarrierParamByID(carrierID int32) CarrierParam {
	return CarrierParam{carrierID: carrierID}
}

func NewCarrierParamByText(carrierText string) CarrierParam {
	return CarrierParam{carrierText: carrierText}
}

func (p *CarrierParam) GetID() int32 {
	return p.carrierID
}

func (p *CarrierParam) GetText() string {
	return p.carrierText
}

func (p *CarrierParam) GetValue() string {
	if p.carrierText != "" {
		return p.carrierText
	}
	return strconv.Itoa(int(p.carrierID))
}
