package flightp2p

import (
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flight_p2p/format"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/utils"
)

func (service *FlightP2PServiceImpl) GetFlightsP2PSummary(debug bool) (format.SummaryResponse, error) {
	response := format.SummaryResponse{}
	flightsCache, dopFlightsCache := service.Storage.FlightStorage().GetFlightsP2POperating()
	for key, flights := range flightsCache {
		departureStation, arrivalStation := utils.ParseFlightP2PKey(key)
		flightCount := len(flights)
		totalFlightsCount := flightCount

		dopFlights, ok := dopFlightsCache[key]
		dopFlightCount := 0
		if ok {
			dopFlightCount = len(dopFlights)
			totalFlightsCount = len(utils.MergeLists(flights, dopFlights))
		}
		responseEntry := format.SummaryResponseEntry{
			DepartureStation:  departureStation,
			ArrivalStation:    arrivalStation,
			FlightsCount:      int32(len(flights)),
			DopFlightsCount:   int32(dopFlightCount),
			TotalFlightsCount: int32(totalFlightsCount),
		}
		if debug {
			responseEntry.Flights = flights
		}
		response.Flights = append(response.Flights, responseEntry)
	}
	return response, nil
}
