package format

import (
	"time"

	dto "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/DTO"
	"a.yandex-team.ru/travel/avia/shared_flights/api/pkg/structs"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/dtutil"
)

type FlightKey struct {
	OperatingCarrier int32
	OperatingFlight  string
}
type Duration struct {
	Duration       time.Duration
	DepartureTime  time.Duration
	DepartureShift time.Duration
	ArrivalTime    time.Duration
	ArrivalShift   time.Duration
	DepartureDate  dtutil.IntDate
	ArrivalDate    dtutil.IntDate
}

type DurationString struct {
	Duration       string
	DepartureTime  string
	DepartureShift string
	ArrivalTime    string
	ArrivalShift   string
	DepartureDate  string
	ArrivalDate    string
}

func (d Duration) Min(d2 Duration) Duration {
	if d.Duration < d2.Duration {
		return d
	}
	return d2
}

type FlightKeyDebugInfo struct {
	FlightKey
	MinDuration DurationString `json:"min_duration"`
}

type Response struct {
	DepartureStations []int32  `json:"departureStations"`
	ArrivalStations   []int32  `json:"arrivalStations"`
	Flights           []Flight `json:"flights"`
}

type CodeshareFlight struct {
	dto.TitledFlight
	Masks []Mask `json:"masks,omitempty"`
}

type Flight struct {
	dto.TitledFlight
	DepartureDatetime string            `json:"departureDatetime"` // datetime with timezone 2020-01-05T20:30:35-03:00
	DepartureTerminal string            `json:"departureTerminal"`
	DepartureStation  int32             `json:"departureStation"`
	ArrivalDatetime   string            `json:"arrivalDatetime"` // datetime with timezone 2020-01-05T20:30:35-03:00
	ArrivalTerminal   string            `json:"arrivalTerminal"`
	ArrivalStation    int32             `json:"arrivalStation"`
	StartDatetime     string            `json:"startDatetime"` // datetime with timezone 2020-01-05T20:30:35-03:00
	TransportModelID  int64             `json:"transportModelID"`
	Codeshares        []CodeshareFlight `json:"codeshares"`
	Route             dto.Route         `json:"route"` // ordered
	Source            string            `json:"source"`
	Banned            string            `json:"banned,omitempty"`
	Masks             []Mask            `json:"masks,omitempty"`
}

type Mask struct {
	From  dtutil.StringDate `json:"from"`
	Until dtutil.StringDate `json:"until"`
	On    int32             `json:"on,omitempty"`
}

type ScheduleResponse struct {
	DepartureStations []int32          `json:"departureStations"`
	ArrivalStations   []int32          `json:"arrivalStations"`
	Flights           []ScheduleFlight `json:"flights"`
}

type ScheduleFlight struct {
	dto.TitledFlight
	DepartureTime     string            `json:"departureTime"`     // 20:30
	DepartureTimezone string            `json:"departureTimezone"` // -03:00
	DepartureTerminal string            `json:"departureTerminal"`
	DepartureStation  int32             `json:"departureStation"`
	ArrivalTime       string            `json:"arrivalTime"`     // 20:30
	ArrivalTimezone   string            `json:"arrivalTimezone"` // -03:00
	ArrivalTerminal   string            `json:"arrivalTerminal"`
	ArrivalStation    int32             `json:"arrivalStation"`
	ArrivalDayShift   int32             `json:"arrivalDayShift"`
	StartTime         string            `json:"startTime"` // 20:30
	StartDayShift     int32             `json:"startDayShift"`
	TransportModelID  int64             `json:"transportModelID"`
	Codeshares        []CodeshareFlight `json:"codeshares"`
	Route             dto.Route         `json:"route"` // ordered
	Banned            []Mask            `json:"banned,omitempty"`
	Masks             []Mask            `json:"masks,omitempty"`
}

type SummaryResponse struct {
	Flights []SummaryResponseEntry `json:"flights"`
}

type SummaryResponseEntry struct {
	DepartureStation  int32    `json:"departureStation"`
	ArrivalStation    int32    `json:"arrivalStation"`
	FlightsCount      int32    `json:"flightsCount"`
	DopFlightsCount   int32    `json:"dopFlightsCount,omitempty"`
	TotalFlightsCount int32    `json:"totalFlightsCount,omitempty"`
	Flights           []string `json:"flights,omitempty"`
}

type PointPair struct {
	StationFrom int32 `json:"station_from"`
	StationTo   int32 `json:"station_to"`
}

type PointPairInfo struct {
	RoutesCount int                  `json:"routes_count"`
	Debug       []FlightKeyDebugInfo `json:"debug,omitempty"`
	MinDuration uint64               `json:"min_duration"`
}

type SegmentInfoResponseItem struct {
	PointPair
	PointPairInfo
}

type SegmentInfoResponse = []SegmentInfoResponseItem

type FlightDeparture struct {
	dto.TitledFlight
	DepartureDatetime string                   `json:"departureDatetime"` // datetime with timezone 2020-01-05T20:30:35-03:00
	DepartureTerminal string                   `json:"departureTerminal"`
	DepartureStation  int32                    `json:"departureStation"`
	ArrivalStation    int32                    `json:"arrivalStation"`
	TransportModelID  int64                    `json:"transportModelID"`
	Source            structs.FlightBaseSource `json:"source"`
	Banned            bool                     `json:"banned,omitempty"`
}

type DirectDatesAndFlights struct {
	DepartureStations []int32           `json:"departureStations"`
	ArrivalStations   []int32           `json:"arrivalStations"`
	Dates             []string          `json:"dates"`
	FlightDepartures  []FlightDeparture `json:"flights,omitempty"`
}

type ResponseByDate struct {
	Forward  DirectDatesAndFlights  `json:"forward"`
	Backward *DirectDatesAndFlights `json:"backward,omitempty"`
}
