package flightp2p

import (
	"time"

	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/dtutil"
)

type timezoneOffsetCacheKey struct {
	Date     dtutil.IntDate
	Timezone *time.Location
}

// timezoneOffsetCache holds mapping from station id to offset in seconds for current time
type timezoneOffsetCache map[timezoneOffsetCacheKey]time.Duration

func (c timezoneOffsetCache) Get(date dtutil.IntDate, timezone *time.Location) time.Duration {
	key := timezoneOffsetCacheKey{date, timezone}
	if offset, ok := c[key]; ok {
		return offset
	}
	offset := c.get(date, timezone)
	c[key] = offset
	return offset
}
func (c timezoneOffsetCache) get(date dtutil.IntDate, timezone *time.Location) time.Duration {
	year, month, day := date.Components()
	_, offset := time.Date(year, month, day, 12, 0, 0, 0, timezone).Zone()
	return time.Duration(offset) * time.Second
}
