package format

import (
	p2pformat "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flight_p2p/format"
)

type Response struct {
	Title     string     `json:"title"`
	CarrierID int32      `json:"airlineID"`
	Schedules []Schedule `json:"schedules"`
}

type Schedule struct {
	Route            []StopPoint      `json:"route"`
	Masks            []p2pformat.Mask `json:"masks"`
	TransportModelID int32            `json:"transportModelID"`
}

type StopPoint struct {
	AirportID         int64  `json:"airportID"`
	AirportCode       string `json:"airportCode,omitempty"`
	ArrivalTerminal   string `json:"arrivalTerminal,omitempty"`
	ArrivalTime       string `json:"arrivalTime,omitempty"`
	ArrivalDayShift   int    `json:"arrivalDayShift,omitempty"`
	DepartureTime     string `json:"departureTime,omitempty"`
	DepartureDayShift int    `json:"departureDayShift,omitempty"`
	DepartureTerminal string `json:"departureTerminal,omitempty"`
}
