package format

import (
	dto "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/DTO"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flight"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flightstatus"
)

type Response struct {
	Station   int32    `json:"station"`
	Direction string   `json:"direction"`
	Flights   []Flight `json:"flights"`
}

type Flight struct {
	dto.TitledFlight
	Datetime         string                    `json:"datetime"`      //datetime with timezone 2020-01-05T20:30:35-03:00
	StartDatetime    string                    `json:"startDatetime"` //datetime with timezone 2020-01-05T20:30:35-03:00
	Terminal         string                    `json:"terminal"`
	Codeshares       []dto.TitledFlight        `json:"codeshares"`
	Status           flightstatus.FlightStatus `json:"status"`
	Route            dto.Route                 `json:"route"` // ordered
	StationFrom      int32                     `json:"stationFrom"`
	StationTo        int32                     `json:"stationTo"`
	Source           string                    `json:"source"`
	TransportModelID int64                     `json:"transportModelID"`
}

type FlightStationResponse struct {
	Station   int32                                `json:"station"`
	Direction string                               `json:"direction"`
	Flights   []flight.FlightSegmentWithCodeshares `json:"flights"`
}
