package flightsdelayed

import (
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flights_delayed/format"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/storage"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/storage/station"
)

type DelayedFlightsService interface {
	GetDelayedFlights(stations []int64, debug, allStations bool) format.Response
}

type DelayedFlightsServiceImpl struct {
	*storage.Storage
}

func NewDelayedFlightsService(
	storage *storage.Storage,
) DelayedFlightsService {
	return &DelayedFlightsServiceImpl{
		Storage: storage,
	}
}

func (service *DelayedFlightsServiceImpl) GetDelayedFlights(stations []int64, debug, allStations bool) format.Response {
	response := format.Response{
		Stations: make([]format.StationElem, 0, len(stations)),
	}

	if allStations {
		stations = service.Storage.StatusStorage().GetDelayedOrCancelledStations()
	}
	for _, currentStation := range stations {
		stationElem := format.StationElem{
			StationID: currentStation,
		}

		if debug {
			stationProto, hasData := service.Storage.Stations().ByID(currentStation)
			if hasData {
				stationElem.StationCode = station.GetStationCode(stationProto)
			}
		}

		delayedFlights, hasDelayed := service.Storage.StatusStorage().GetDelayedFlights(currentStation)
		if !hasDelayed {
			stationElem.DelayedFlightsCount = 0
		} else {
			stationElem.DelayedFlightsCount = len(delayedFlights)
			if debug {
				stationElem.DelayedFlights = make([]string, 0, len(delayedFlights))
				for key := range delayedFlights {
					stationElem.DelayedFlights = append(stationElem.DelayedFlights, key)
				}
			}
		}

		cancelledFlights, hasCancelled := service.Storage.StatusStorage().GetCancelledFlights(currentStation)
		if !hasCancelled {
			stationElem.CancelledFlightsCount = 0
		} else {
			stationElem.CancelledFlightsCount = len(cancelledFlights)
			if debug {
				stationElem.CancelledFlights = make([]string, 0, len(cancelledFlights))
				for key := range cancelledFlights {
					stationElem.CancelledFlights = append(stationElem.CancelledFlights, key)
				}
			}
		}

		response.Stations = append(response.Stations, stationElem)
	}
	return response
}
