package format

type Response struct {
	Stations []StationElem `json:"stations"`
}

type StationElem struct {
	StationID             int64    `json:"id"`
	StationCode           string   `json:"code,omitempty"`
	CancelledFlightsCount int      `json:"cancelled"`
	DelayedFlightsCount   int      `json:"delayed"`
	CancelledFlights      []string `json:"cancelledFlights,omitempty"` // only shown in debug mode
	DelayedFlights        []string `json:"delayedFlights,omitempty"`   // only shown in debug mode
}
