package storage

import (
	"a.yandex-team.ru/library/go/core/xerrors"
)

func (service *Service) Available() error {
	if service == nil {
		return xerrors.New("no global service available")
	}
	instance := service.instance
	if instance == nil {
		return xerrors.New("No global service instance available")
	}
	storage := instance.storage
	if storage == nil {
		return xerrors.New("no internal storage available")
	}

	if !storage.IsAvailable {
		return xerrors.New("shared flights api is not available")
	}

	return nil
}
