package station

import (
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/storage"
	"a.yandex-team.ru/travel/proto/shared_flights/snapshots"
)

type StationService struct {
	storage *storage.Storage
}

func NewStationService(storage *storage.Storage) *StationService {
	return &StationService{storage: storage}
}

type StationProvider interface {
	ByID(id int64) (*snapshots.TStationWithCodes, bool)
	ByIata(code string) (*snapshots.TStationWithCodes, bool)
	BySirena(code string) (*snapshots.TStationWithCodes, bool)
	ByIcao(code string) (*snapshots.TStationWithCodes, bool)
}

func (service *StationService) StationProvider() StationProvider {
	return service.storage.Stations()
}
