package format

import (
	dto "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/DTO"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/dtutil"
)

type Response struct {
	Station   int32    `json:"station"`
	Direction string   `json:"direction"`
	Flights   []Flight `json:"flights"`
}

type Flight struct {
	dto.TitledFlight
	Schedules []Schedule `json:"schedules"`
}

type Schedule struct {
	Time             dtutil.StringTime `json:"time"`
	Terminal         string            `json:"terminal"`
	StartTime        dtutil.StringTime `json:"startTime"`
	StartDayShift    int32             `json:"startDayShift"`
	TransportModelID int32             `json:"transportModelID"`
	Route            dto.Route         `json:"route"` // ordered
	Masks            []Mask            `json:"masks"`
}

type Mask struct {
	From  dtutil.StringDate `json:"from"`
	Until dtutil.StringDate `json:"until"`
	On    int32             `json:"on"`
}
