package storage

import (
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/accessors"
	aeroflotvariants "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/aeroflot_variants"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/carrier"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flight"
	flightp2p "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flight_p2p"
	flightschedule "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flight_schedule"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flightboard"
	flightsdelayed "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flights_delayed"
	flightsnetwork "a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/flights_network"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/station"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/stationschedule"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/threads"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/services/storage/timezone"
	"a.yandex-team.ru/travel/avia/shared_flights/api/internal/storage"
)

// External wrapper to switch underlying service
type Service struct {
	instance *ServiceInstance
	shutdown bool
}

func (service *Service) Shutdown() {
	service.shutdown = true
}

func (service *Service) IsShutdown() bool {
	return service.shutdown
}

func (service *Service) SwitchTo(service2 *Service) {
	service.instance = service2.instance
}

func (service *Service) Instance() *ServiceInstance {
	return service.instance
}

type ServiceInstance struct {
	flight.FlightService
	flightp2p.FlightP2PService
	flightboard.FlightBoardService
	flightsdelayed.DelayedFlightsService
	flightschedule.FlightScheduleService
	flightsnetwork.FlightsNetworkService
	stationschedule.StationScheduleService
	aeroflotvariants.AeroflotVariantsService
	accessors.AccessorSerivce
	*station.StationService
	timezone.TimeZoneUtil
	*carrier.CarrierService
	storage *storage.Storage
}

func (s ServiceInstance) Storage() *storage.Storage {
	return s.storage
}

func NewStorageService(storage *storage.Storage) *Service {
	tzutil := timezone.NewTimeZoneUtil(storage.Timezones(), storage.Stations())
	threadRoute := threads.NewThreadRouteService(storage, tzutil)
	carrierService := carrier.NewCarrierService(storage.CarrierStorage(), storage.IataCorrector())
	flightService := flight.NewFlightService(storage, tzutil, carrierService)
	return &Service{
		instance: &ServiceInstance{
			flightService,
			flightp2p.NewFlightP2PService(storage, tzutil),
			flightboard.NewFlightBoardService(storage, tzutil, threadRoute),
			flightsdelayed.NewDelayedFlightsService(storage),
			flightschedule.NewFlightScheduleService(storage, flightService),
			flightsnetwork.NewFlightsNetworkService(storage),
			stationschedule.NewStationScheduleService(storage, tzutil, threadRoute),
			aeroflotvariants.NewAeroflotVariantsService(storage, tzutil),
			accessors.NewAccessorService(storage),
			station.NewStationService(storage),
			tzutil,
			carrierService,
			storage,
		},
	}
}
